﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SmartDeviceSNMP;
using Microsoft.WindowsCE.Forms;

namespace SmartDeviceSNMP
{
    public partial class Form1 : Form
    {
        private MyTreeNode iso;
        private MyTreeNode iso1;
        public List<String> OIDs = new List<String>();
        public List<String> OIDSet = new List<String>();
        public static List<String> Names = new List<string>();
        public static int namesCounter = 0;

        public Form1()
        {
            InitializeComponent();
            createMibTree();
            addItemsToTreeView();
        }



        private void menuItem1_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        public void createMibTree()
        {
            #region create MIB Tree for GET
            iso = new MyTreeNode("iso", 1, "");
            MyTreeNode organization = new MyTreeNode("organization", 3, "");
            iso.Nodes.Add(organization);
            MyTreeNode DoD = new MyTreeNode("DoD", 6, "");
            organization.Nodes.Add(DoD);
            MyTreeNode internet = new MyTreeNode("internet", 1, "");
            DoD.Nodes.Add(internet);
            MyTreeNode managment = new MyTreeNode("managment", 2, "");
            internet.Nodes.Add(managment);
            MyTreeNode Mib2 = new MyTreeNode("Mib2", 1, "");
            managment.Nodes.Add(Mib2);
            MyTreeNode system = new MyTreeNode("system", 1, "");

            Mib2.Nodes.Add(system);
            system.Nodes.Add(new MyTreeNode("sysDescr", 1, "A textual description of the entity. This value should include the full name and version identification of the systems hardware type software operating-system, and networking software  It is mandatory that this only contain printable ASCII characters"));
            system.Nodes.Add(new MyTreeNode("sysObjectID", 2, "The vendor authoritative identification of the network management subsystem contained in the entity."));
            system.Nodes.Add(new MyTreeNode("sysUpTime", 3, "The time (in hundredths of a second) since the network management portion of the system was last re-initialized."));
            system.Nodes.Add(new MyTreeNode("sysContact", 4, "The textual identification of the contact person for this managed node, together with information on how to contact this person."));
            system.Nodes.Add(new MyTreeNode("sysName", 5, "An administratively assigned name for this managed node. By convention, this is the nodes fully qualified domain name."));
            system.Nodes.Add(new MyTreeNode("sysLocation", 6, "The physical location of the node"));
            system.Nodes.Add(new MyTreeNode("sysServices", 7, "A value which indicates the set of services that this entity primarily offers"));



            MyTreeNode ip = new MyTreeNode("ip", 4, "");
            Mib2.Nodes.Add(ip);
            ip.Nodes.Add(new MyTreeNode("ipForwarding", 1, ""));
            ip.Nodes.Add(new MyTreeNode("ipDefaultTTL", 2, ""));
            ip.Nodes.Add(new MyTreeNode("ipInReceives", 3, ""));
            ip.Nodes.Add(new MyTreeNode("ipInHdrErrors", 4, ""));
            ip.Nodes.Add(new MyTreeNode("ipInAddrErrors", 5, ""));
            ip.Nodes.Add(new MyTreeNode("ipForwDatagrams", 6, ""));
            ip.Nodes.Add(new MyTreeNode("ipInUnknownProtos", 7, ""));
            ip.Nodes.Add(new MyTreeNode("ipInDiscards", 8, ""));
            ip.Nodes.Add(new MyTreeNode("ipInDelivers", 9, ""));
            ip.Nodes.Add(new MyTreeNode("ipOutRequests", 10, ""));
            ip.Nodes.Add(new MyTreeNode("ipOutDiscards", 11, ""));
            ip.Nodes.Add(new MyTreeNode("ipOutNoRoutes", 12, ""));
            ip.Nodes.Add(new MyTreeNode("ipReasmTimeout", 13, ""));
            ip.Nodes.Add(new MyTreeNode("ipReasmReqds", 14, ""));
            ip.Nodes.Add(new MyTreeNode("ipReasmOKs", 15, ""));
            ip.Nodes.Add(new MyTreeNode("ipReasmFails", 16, ""));
            ip.Nodes.Add(new MyTreeNode("ipFragOKs", 17, ""));
            ip.Nodes.Add(new MyTreeNode("ipFragFails", 18, ""));
            ip.Nodes.Add(new MyTreeNode("ipFragCreates", 19, ""));
            ip.Nodes.Add(new MyTreeNode("ipAddrTable", 20, ""));
            ip.Nodes.Add(new MyTreeNode("ipRouteTable", 21, ""));
            ip.Nodes.Add(new MyTreeNode("ipNetToMediaTable", 22, ""));
            ip.Nodes.Add(new MyTreeNode("ipRoutingDiscards", 23, ""));

            MyTreeNode tcp = new MyTreeNode("tcp", 6, "");
            Mib2.Nodes.Add(tcp);
            tcp.Nodes.Add(new MyTreeNode("tcpRtoAlgorithm", 1, ""));
            tcp.Nodes.Add(new MyTreeNode("tcpRtoMin", 2, ""));
            tcp.Nodes.Add(new MyTreeNode("tcpRtoMax", 3, ""));
            tcp.Nodes.Add(new MyTreeNode("tcpMaxConn", 4, ""));
            tcp.Nodes.Add(new MyTreeNode("tcpActiveOpens", 5, ""));
            tcp.Nodes.Add(new MyTreeNode("tcpPassiveOpens", 6, ""));
            tcp.Nodes.Add(new MyTreeNode("tcpAttemptFails", 7, ""));
            tcp.Nodes.Add(new MyTreeNode("tcpEstabResets", 8, ""));
            tcp.Nodes.Add(new MyTreeNode("tcpCurrEstab", 9, ""));
            tcp.Nodes.Add(new MyTreeNode("tcpInSegs", 10, ""));
            tcp.Nodes.Add(new MyTreeNode("tcpOutSegs", 11, ""));
            tcp.Nodes.Add(new MyTreeNode("tcpRetransSegs", 12, ""));
            tcp.Nodes.Add(new MyTreeNode("tcpConnTable", 13, ""));
            tcp.Nodes.Add(new MyTreeNode("tcpInErrs", 14, ""));
            tcp.Nodes.Add(new MyTreeNode("tcpOutRsts", 15, ""));

            MyTreeNode udp = new MyTreeNode("udp", 7, "");
            Mib2.Nodes.Add(udp);
            udp.Nodes.Add(new MyTreeNode("udpInDatagrams", 1, ""));
            udp.Nodes.Add(new MyTreeNode("udpNoPorts", 2, ""));
            udp.Nodes.Add(new MyTreeNode("udpInErrors", 3, ""));
            udp.Nodes.Add(new MyTreeNode("udpOutDatagrams", 4, ""));
            udp.Nodes.Add(new MyTreeNode("udpTable", 5, ""));
            #endregion

            #region create MIB tree for SET

            iso1 = new MyTreeNode("iso", 1, "");
            MyTreeNode organization1 = new MyTreeNode("organization", 3, "");
            iso1.Nodes.Add(organization1);
            MyTreeNode DoD1 = new MyTreeNode("DoD", 6, "");
            organization1.Nodes.Add(DoD1);
            MyTreeNode internet1 = new MyTreeNode("internet", 1, "");
            DoD1.Nodes.Add(internet1);
            MyTreeNode managment1 = new MyTreeNode("managment", 2, "");
            internet1.Nodes.Add(managment1);
            MyTreeNode Mib21 = new MyTreeNode("Mib2", 1, "");
            managment1.Nodes.Add(Mib21);
            MyTreeNode system1 = new MyTreeNode("system", 1, "");

            Mib21.Nodes.Add(system1);
            system1.Nodes.Add(new MyTreeNode("sysContact", 4, "The textual identification of the contact person for this managed node, together with information on how to contact this person."));
            system1.Nodes.Add(new MyTreeNode("sysName", 5, "An administratively assigned name for this managed node. By convention, this is the nodes fully qualified domain name."));
            system1.Nodes.Add(new MyTreeNode("sysLocation", 6, "The physical location of the node"));

            #endregion

        }



        public void addItemsToTreeView()
        {
            treeView1.BeginUpdate();
            treeView1.Nodes.Add(iso);
            //addNodesToTree(iso.getList(), node);
            treeView1.EndUpdate();
            treeView1.ExpandAll();

            treeView2.BeginUpdate();
            treeView2.Nodes.Add(iso1);
            //addNodesToTree(iso.getList(), node);
            treeView2.EndUpdate();
            treeView2.ExpandAll();

        }

        private void treeView1_AfterSelect(object sender, TreeViewEventArgs e)
        {

            if (e.Node.Nodes.Count == 0) // zeby tylko koncowe
            {

                if (((MyTreeNode)e.Node).getSelected() == true)//zaznaczony jest juz wybrany
                {
                    addOIDbutton.Text = "Remove";
                }
                else
                {
                    addOIDbutton.Text = "Select";
                }

                listBox1.Items.Clear();
                int i = 0;
                string[] words = ((MyTreeNode)e.Node).getDescription().ToString().Split(' ');//tablica zwierajaca wyrazy
                while (i < words.Length)
                {
                    string line = "";
                    while ((line.Length + words[i].Length) < 21)
                    {
                        line = line + " " + words[i];
                        i++;
                        if (i == words.Length) break; // bo tablica zaczyna sie od 0
                    }
                    listBox1.Items.Add(line);
                }





            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }

        private void Form1_DoubleClick(object sender, EventArgs e)
        {

        }

        private void addOIDbutton_Click(object sender, EventArgs e)
        {

            if (treeView1.SelectedNode.Nodes.Count == 0)// zeby tylko koncowe
            {

                if (((MyTreeNode)treeView1.SelectedNode).getSelected() == false)// clikam zeby wybrac
                {
                    ((MyTreeNode)treeView1.SelectedNode).setSelected(true);
                    addOIDbutton.Text = "Remove";
                    ((MyTreeNode)treeView1.SelectedNode.Parent).getNumber();
                    string OID = "0";   //tworzenie stringa 1.2.3 ..
                    TreeNode treeNode = null;
                    treeNode = treeView1.SelectedNode;
                    while (treeNode.Parent != null)
                    {
                        OID = ((MyTreeNode)treeNode).getNumber().ToString() + "." + OID.ToString();
                        treeNode = treeNode.Parent;
                        if (treeNode.Parent == null) OID = ((MyTreeNode)treeNode).getNumber().ToString() + "." + OID.ToString();
                    }

                    treeView1.SelectedNode.ForeColor = Color.Blue;
                    treeView1.SelectedNode.BackColor = Color.LightGray;

                    //listBox1.Items.Add(OID.ToString());
                    //listBox1.Items.Add(((MyTreeNode)treeView1.SelectedNode).getNumber().ToString());

                    OIDs.Add(OID);
                    Names.Add(((MyTreeNode)treeView1.SelectedNode).getName().ToString());
                    foreach (string s in OIDs)
                    {
                        listBox1.Items.Add(s.ToString());
                    }
                    foreach (string s in Names)
                    {
                        listBox1.Items.Add(s.ToString());
                    }


                }
                else // klikam zeby odznaczyc
                {
                    ((MyTreeNode)treeView1.SelectedNode).setSelected(false);
                    addOIDbutton.Text = "Select";

                    string OID = "0";   //tworzenie stringa 1.2.3 ..
                    TreeNode treeNode = null;
                    treeNode = treeView1.SelectedNode;
                    while (treeNode.Parent != null)
                    {
                        OID = ((MyTreeNode)treeNode).getNumber().ToString() + "." + OID.ToString();
                        treeNode = treeNode.Parent;
                        if (treeNode.Parent == null) OID = ((MyTreeNode)treeNode).getNumber().ToString() + "." + OID.ToString();
                    }

                    OIDs.Remove(OID);
                    Names.Remove(((MyTreeNode)treeView1.SelectedNode).getName().ToString());
                    foreach (string s in OIDs)
                    {
                        listBox1.Items.Add(s.ToString());
                    }


                    treeView1.SelectedNode.ForeColor = Color.Black;
                    treeView1.SelectedNode.BackColor = Color.White;
                }
            }


        }

        private void listBox1_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

        private void buttonStart_Click(object sender, EventArgs e)
        {
            

            SNMPMgr SA;
            SNMPManager formAction = new SNMPManager(this);
            //SA.DataReceived += new SNMPAgent.ReveivedDataEventHandler(formAction.dataReceivedEventHandler);
            formAction.Visible = true;

            foreach (String s in OIDs)
            {
                SA = new SNMPMgr();
                SA.DataReceived += new SNMPMgr.ReveivedDataEventHandler(formAction.dataReceivedEventHandler);
                //SA.SendRequest("1.3.6.1.2.1.1.5.0");
                SA.SendRequest(s);
                //listBox1.Items.Add(SA.getData(s));
                namesCounter++;
            }

            namesCounter = 0;
            SystemSettings.ScreenOrientation = ScreenOrientation.Angle90;

        }

        private void menuItem2_Click(object sender, EventArgs e)
        {
            FormSettings formSettings = new FormSettings();
            formSettings.Visible = true;


        }

        private void buttonSet_Click(object sender, EventArgs e)
        {
            SNMPMgr SA;
            SA = new SNMPMgr();
            if (OIDSet.Count > 0)
            {
                SA.SendSet(OIDSet.Last(), textBox1.Text.ToString());
            }
        }

        private void treeView1_AfterSelect_1(object sender, TreeViewEventArgs e)
        {
            if (e.Node.Nodes.Count == 0) // zeby tylko koncowe
            {

                if (((MyTreeNode)e.Node).getSelected() == true)//zaznaczony jest juz wybrany
                {
                    addOIDbutton.Text = "Remove";
                }
                else
                {
                    addOIDbutton.Text = "Select";
                }

                listBox1.Items.Clear();
                int i = 0;
                string[] words = ((MyTreeNode)e.Node).getDescription().ToString().Split(' ');//tablica zwierajaca wyrazy
                while (i < words.Length)
                {
                    string line = "";
                    while ((line.Length + words[i].Length) < 21)
                    {
                        line = line + " " + words[i];
                        i++;
                        if (i == words.Length) break; // bo tablica zaczyna sie od 0
                    }
                    listBox1.Items.Add(line);
                }
            }
        }

        private void buttonSelectSet_Click(object sender, EventArgs e)
        {
            if (treeView2.SelectedNode.Nodes.Count == 0)// zeby tylko koncowe
            {

                if (((MyTreeNode)treeView2.SelectedNode).getSelected() == false)// clikam zeby wybrac
                {
                    ((MyTreeNode)treeView2.SelectedNode).setSelected(true);
                    buttonSelectSet.Text = "Remove";
                    ((MyTreeNode)treeView1.SelectedNode.Parent).getNumber();
                    string OID = "0";   //tworzenie stringa 1.2.3 ..
                    TreeNode treeNode = null;
                    treeNode = treeView2.SelectedNode;
                    while (treeNode.Parent != null)
                    {
                        OID = ((MyTreeNode)treeNode).getNumber().ToString() + "." + OID.ToString();
                        treeNode = treeNode.Parent;
                        if (treeNode.Parent == null) OID = ((MyTreeNode)treeNode).getNumber().ToString() + "." + OID.ToString();
                    }

                    treeView2.SelectedNode.ForeColor = Color.Blue;
                    treeView2.SelectedNode.BackColor = Color.LightGray;

                    //listBox1.Items.Add(OID.ToString());
                    //listBox1.Items.Add(((MyTreeNode)treeView1.SelectedNode).getNumber().ToString());

                    OIDSet.Add(OID);
                    foreach (string s in OIDs)
                    {
                        //listBox2.Items.Add(s.ToString());
                    }

                }
                else // klikam zeby odznaczyc
                {
                    ((MyTreeNode)treeView2.SelectedNode).setSelected(false);
                    buttonSelectSet.Text = "Select";

                    string OID = "0";   //tworzenie stringa 1.2.3 ..
                    TreeNode treeNode = null;
                    treeNode = treeView2.SelectedNode;
                    while (treeNode.Parent != null)
                    {
                        OID = ((MyTreeNode)treeNode).getNumber().ToString() + "." + OID.ToString();
                        treeNode = treeNode.Parent;
                        if (treeNode.Parent == null) OID = ((MyTreeNode)treeNode).getNumber().ToString() + "." + OID.ToString();
                    }

                    OIDSet.Remove(OID);
                    foreach (string s in OIDs)
                    {
                        //listBox2.Items.Add(s.ToString());
                    }


                    treeView2.SelectedNode.ForeColor = Color.Black;
                    treeView2.SelectedNode.BackColor = Color.White;
                }
            }


        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {

        }
    }
}
