﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Microsoft.WindowsCE.Forms;

namespace SmartDeviceSNMP
{
    public partial class SNMPManager : Form
    {
        public SNMPManager(Form1 form1)
        {
            InitializeComponent();


            #region ListView
            listView1.View = View.Details;
            listView1.Columns.Add("NAME", 80, HorizontalAlignment.Left);
            listView1.Columns.Add("OID", 120, HorizontalAlignment.Left);
            listView1.Columns.Add("DATA", 250, HorizontalAlignment.Left);
            #endregion

        }

        public void dataReceivedEventHandler(object sender, EventArgs e, List<String> data)
        {
            foreach (String s in data)
            {
                //listBox1.Items.Add(s);
                int i = 0;
                string[] words = s.Split(' ');//tablica zwierajaca wyrazy
                while (i < words.Length)
                {
                    string line = "";
                    while ((line.Length + words[i].Length) < 40)
                    {
                        line = line + " " + words[i];
                        i++;
                        if (i == words.Length) break; // bo tablica zaczyna sie od 0
                    }
                    listBox1.Items.Add(line);
                }
            }
            listBox1.Items.Add(" ");

            string id = data.Last().Substring(data.Last().IndexOf("Id")+3,data.Last().IndexOf(";")-data.Last().IndexOf("Id")-3);
            string dataString = data.Last().Substring(data.Last().IndexOf("Data")+5, data.Last().Length - data.Last().IndexOf("Data")-5);
            
            ListViewItem listViewItem = new ListViewItem(Form1.Names.ElementAt(Form1.namesCounter).ToString());
            listViewItem.SubItems.Add(id.ToString());
            listViewItem.SubItems.Add(dataString.ToString());
            listView1.Items.Add(listViewItem);

        }

        private void FormAction_KeyDown(object sender, KeyEventArgs e)
        {
            if ((e.KeyCode == System.Windows.Forms.Keys.Up))
            {
                // Up
            }
            if ((e.KeyCode == System.Windows.Forms.Keys.Down))
            {
                // Down
            }
            if ((e.KeyCode == System.Windows.Forms.Keys.Left))
            {
                // Left
            }
            if ((e.KeyCode == System.Windows.Forms.Keys.Right))
            {
                // Right
            }
            if ((e.KeyCode == System.Windows.Forms.Keys.Enter))
            {
                // Enter
            }

        }

        private void SNMPManager_Deactivate(object sender, EventArgs e)
        {
            SystemSettings.ScreenOrientation = ScreenOrientation.Angle0;
        }
    }
}