﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Text;

namespace SmartDeviceSNMP
{
    using System;
    using System.Linq;
    using System.Collections.Generic;
    using System.Text;
    using Lextm.SharpSnmpLib;
    using Lextm.SharpSnmpLib.Messaging;
    using Lextm.SharpSnmpLib.Security;
    using System.Net;

        class SNMPMgr
        {
            public delegate void ReveivedDataEventHandler(object sender, EventArgs e, List<String> data);

            public event ReveivedDataEventHandler DataReceived;

            string community = "public";
            string communityP = "private";
            VersionCode version = VersionCode.V1;
            int timeout = 1000;
            string user = string.Empty;
            string authentication = string.Empty;
            string authPhrase = string.Empty;
            string privacy = string.Empty;
            string privPhrase = string.Empty;

            public System.Net.IPEndPoint receiver = new IPEndPoint(IPAddress.Parse("192.168.1.1"), 161);
            public List<Lextm.SharpSnmpLib.Variable> vList = new List<Variable>();

            public SNMPMgr()
            {
            }

            public SNMPMgr(string _community, IPEndPoint _receiver)
            {
                community = _community;
                receiver = _receiver;
            }

            public List<String> SendRequest(String OID)
            {
                List<string> lista = new List<string>();
                vList.Add(new Variable(new ObjectIdentifier(OID)));
                GetRequestMessage getRequestMessage = new GetRequestMessage(1, version, new OctetString(community), vList);

                ISnmpMessage isnmpMessage = getRequestMessage.GetResponse(timeout, receiver);

                foreach (Variable varia in isnmpMessage.Pdu.Variables)
                {
                    lista.Add(varia.ToString());
                }
                OnDataReceived(EventArgs.Empty, lista);
                return lista;

            }

            public List<String> SendSet(String OID, string newValue)
            {
                List<Lextm.SharpSnmpLib.Variable> vList = new List<Variable>();
                List<string> lista = new List<string>();
                ISnmpData data = new OctetString(newValue);
                vList.Add(new Variable(new ObjectIdentifier(OID), data));

                SetRequestMessage setRequestMessage = new SetRequestMessage(1, version, new OctetString(communityP), vList);
                
                ISnmpMessage isnmpMessage = setRequestMessage.GetResponse(timeout, receiver);
                foreach (Variable varia in isnmpMessage.Pdu.Variables)
                {
                    lista.Add(varia.ToString());
                }

                OnDataReceived(EventArgs.Empty, lista);
                return lista;

            }

            protected virtual void OnDataReceived(EventArgs e, List<String> data)
            {
                if (DataReceived != null)
                    DataReceived(this, e, data);
            }

            public string getData(String OID)
            {
                return String.Empty;
            }


            /*        public string getData(String OID)
                    {
                        int commlength, miblength, datatype, datalength, datastart;
                        string output;
                        int intOutPut = 0;
                        SNMP conn = new SNMP();
                        byte[] response = new byte[1024];
                        Console.WriteLine("Device SNMP information:");
                        // Send sysName SNMP request and get the response
                        response = conn.get("get", "192.168.1.1", "public", OID.ToString());
                        if (response[0] == 0xff)
                        {
                            Console.WriteLine("No response from {0}", "192.168.1.1");
                        }
            
            
              
            
                        // Get the community name and MIB lengths from the packet
                        commlength = Convert.ToInt16(response[6]);
                        miblength = Convert.ToInt16(response[23 + commlength]);
                        // Extract the MIB data from the SNMP response
                        datatype = Convert.ToInt16(response[24 + commlength + miblength]);
                        datalength = Convert.ToInt16(response[25 + commlength + miblength]);
                        datastart = 26 + commlength + miblength;
                        if (datatype == 2)
                        {
                            // The sysUptime value may by a multi-byte integer
                            // Each byte read must be shifted to the higher byte order
                            while (datalength > 0)
                            {
                                intOutPut = (intOutPut << 8) + response[datastart++];
                                datalength--;
                            }
                            OnDataReceived(EventArgs.Empty,intOutPut.ToString() + "czesc");
                            return (intOutPut.ToString() + " " + datatype.ToString()).ToString();

                        }
                        else
                        {
                            output = Encoding.ASCII.GetString(response, datastart, datalength);
                            OnDataReceived(EventArgs.Empty, output.ToString() + "czesc");
                            return (output.ToString() + " " + datatype.ToString()).ToString();
                        }

     
               }*/
        }
   

}
