﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Text;
using System.IO;
using OpenNETCF.Net.NetworkInformation;

namespace WLANBasic1009
{
    public class LogSaver
    {
        public static bool saveToFile=false;
        public static bool saveSelectedOnly=false;
        public static bool includeGPSinLog = false;
        public static DateTime executionTime = DateTime.Now;
        public static string logFile;
        public static System.IO.TextWriter tw;
        public static void createLogFile()
        {
        logFile = executionTime.ToString().Replace(@"/", @"_").Replace(@"\", @"_").Replace(":", "-").Replace(" ", "_") + ".txt";
        tw = new StreamWriter("WiFiScaner" + logFile);
        }

        public static void saveToLog(AccessPointCollection accessPoints,List<string> selectedMACs)
        {
            if (saveToFile)
            {
                tw.WriteLine(DateTime.Now.ToLongTimeString());
                if (includeGPSinLog)
                {
                    if (GPS.gpsWorking)
                    {
                        tw.WriteLine(GPS.getNewLine().ElementAt(0).ToString() + " " + GPS.getNewLine().ElementAt(1).ToString());
                    }
                    else
                    {
                        tw.WriteLine("GPS No Data");
                    }
                }
                if (saveSelectedOnly)
                {
                    foreach (AccessPoint ap in accessPoints)
                    {
                        if (selectedMACs.Contains(ap.PhysicalAddress.ToString()))
                        {
                            tw.WriteLine("SSID: " + ap.Name.ToString() + " RSS: " + ap.SignalStrength.Decibels.ToString()+ " Channel: " + ap.Channel.ToString() + " MAC: " + ap.PhysicalAddress.ToString() + " Privacy " + (ap.Privacy == 0 ? "Open" : "WEP").ToString());
                        }
                    }
                }
                else
                {
                    foreach (AccessPoint ap in accessPoints)
                    {
                        tw.WriteLine("SSID: " + ap.Name.ToString() + "RSS: " + ap.SignalStrength.Decibels.ToString() +" Channel: " + ap.Channel.ToString() + " MAC: " + ap.PhysicalAddress.ToString() + " Privacy" + (ap.Privacy == 0 ? "Open" : "WEP").ToString());
                    }
                }
            }
        }

        public static void closeLogFile()
        {
            tw.Close();
        }
    }
}
