﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO.Ports;

namespace WLANBasic1009
{
    public partial class Settings : Form
    {
        public static EventHandler settingsEventHandler;

        public Settings()
        {
            settingsEventHandler = new EventHandler(settingsTimerHandler);
            InitializeComponent();
            trackBar1.Value = MyTimer.delay;
            checkBoxSaveLog.Checked = LogSaver.saveToFile;
            checkBoxIncludeSelected.Checked = LogSaver.saveSelectedOnly;
            checkBoxGPS.Checked=LogSaver.includeGPSinLog;

            foreach(string serialPortName in SerialPort.GetPortNames())
            {
                listBox1.Items.Add(serialPortName.ToString());
            }
        }

        private void label1_ParentChanged(object sender, EventArgs e)
        {

        }

        private void label2_ParentChanged(object sender, EventArgs e)
        {

        }

        private void trackBar1_ValueChanged(object sender, EventArgs e)
        {
            label1.Text = trackBar1.Value.ToString();
            MyTimer.delay = trackBar1.Value;
        }

        private void Settings_Closing(object sender, CancelEventArgs e)
        {
            
        }

        private void Settings_Closed(object sender, EventArgs e)
        {
            
        }

        private void Settings_Deactivate(object sender, EventArgs e)
        {
            MyTimer.isTime -= Settings.settingsEventHandler;
            MyTimer.isTime += Form1.mainFormEventHandler;
            Form1.refreshMainFrom = true;
            this.Dispose();
        }

        public void settingsTimerHandler(object sender, EventArgs args)
        {
            //AccessPointsList.Refresh();
        }

        private void label5_ParentChanged(object sender, EventArgs e)
        {

        }

        private void checkBoxIncludeSelected_CheckStateChanged(object sender, EventArgs e)
        {
            if (checkBoxIncludeSelected.Checked == true)
            {
                LogSaver.saveSelectedOnly = true;
            }
            else
            {
                LogSaver.saveSelectedOnly = false;
            }    
        }

        private void checkBoxSaveLog_CheckStateChanged(object sender, EventArgs e)
        {
            if (checkBoxSaveLog.Checked == true)
            {
                LogSaver.saveToFile = true;
                if(LogSaver.tw==null)
                {
                    LogSaver.createLogFile();
                }
            }
            else
            {
                LogSaver.saveToFile = false;
            }
        }

        private void checkBoxGPS_CheckStateChanged(object sender, EventArgs e)
        {
            if (checkBoxGPS.Checked == true)
            {
                LogSaver.includeGPSinLog = true;
            }
            else
            {
                LogSaver.includeGPSinLog = false;
            }

        }

        private void listBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            
        }

  
    }
}