﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using OpenNETCF.Net.NetworkInformation;


namespace WLANBasic1009
{
    public partial class details : Form  
    {
        private MyTimer timer;
        private List<int> signalStrengthList = new List<int>();
        int xReference = 230;
        int previousSingnalStrength = 0;
      
       public details()
        {
            InitializeComponent();
            //timer = new MyTimer();
            signalStrengthList.Add(0);
        }  

        private void button1_Click(object sender, EventArgs e)
        {
            timer.stopTimer();
        }
        
        public void refresh(AccessPoint AP)
        {
            this.listBox1.Items.Clear();
            this.listBox1.Items.Add("Time " + DateTime.Now.Hour.ToString() + ":" + DateTime.Now.Minute.ToString() + ":" + DateTime.Now.Second.ToString());
            this.listBox1.Items.Add("Name: " + AP.Name);
            this.listBox1.Items.Add("Infrastucture Type: " + AP.NetworkTypeInUse);
            this.listBox1.Items.Add("PhysicalAddress: " + AP.PhysicalAddress);
            this.listBox1.Items.Add("Channel: " + AP.Channel.ToString());
            this.listBox1.Items.Add("Privacy: " + (AP.Privacy == 0 ? "open" : "WEP"));
            this.listBox1.Items.Add("SignalStrength: " + AP.SignalStrength.Decibels + "[dB]");
            this.listBox1.Items.Add("SupportedRates");
            foreach (int rate in AP.SupportedRates)
            {
                this.listBox1.Items.Add("     -" + rate + "[kb/s]");
            }
           
            signalStrengthList.Add(AP.SignalStrength.Decibels);

            Graphics g = this.CreateGraphics();
            SolidBrush solidBrush = new SolidBrush(Color.Yellow);
            Pen myPenBlue = new Pen(Color.Blue);
            Pen myPenRed = new Pen(Color.Red);
            g.DrawRectangle(myPenBlue, 10, 180, 220, 80);
            g.FillRectangle(solidBrush, 10, 180, 220, 80);

            // g.DrawLine(myPenRed, xReference, 190 - previousSingnalStrength, xReference + 2, 190 - AP.SignalStrength.Decibels);
            // previousSingnalStrength = AP.SignalStrength.Decibels;
            

            signalStrengthList.Add(AP.SignalStrength.Decibels);
            xReference = 230;
            if (signalStrengthList.Count < 110)
            {
                for (int i = signalStrengthList.Count - 1; i > 0; i--)
                {
                    g.DrawLine(myPenRed, xReference, 190 - signalStrengthList.ElementAt(i), xReference - 1, 190 - signalStrengthList.ElementAt(i - 1));
                    xReference = xReference - 1;
                }
            }
            else 
            {
                for (int i = signalStrengthList.Count - 1; i > signalStrengthList.Count - 111; i--)
                {
                    g.DrawLine(myPenRed, xReference, 190 - signalStrengthList.ElementAt(i), xReference - 2, 190 - signalStrengthList.ElementAt(i - 1));
                    xReference = xReference - 2;
                }
            }
        }


        private void details_Closed(object sender, EventArgs e)
        {
            
        }

        private void details_Closing(object sender, CancelEventArgs e)
        {
         
        }

        private void details_Deactivate(object sender, EventArgs e)
        {
            timer.stopTimer();
            this.Dispose(true);
        }


    }
}